function [Kx_sim,Kf_sim,H_sim,G_sim,M_sim,L_sim] = Simultaneous_observer_controller(A,B,F,D1,C,D2)

[n,m] = size(B);
[~,q] = size(F);
[p,q1] = size(D2);

bar_A = [A F zeros(n,q1); zeros(q+q1,q+n+q1)]; 
bar_C = [C zeros(p,q) D2]; 
Cx = eye(n);
Cex = eye(n);
Cefa = [1;1];
Cefs = [1;0];

Kf_sim = -pinv(B)*F;

% Solve LMIs using Matlab LMI toolbox
gamma = 0.2;
beta = 1.0e-3;

setlmis([]);

P = lmivar(1,[n,1]); 
Q = lmivar(1,[n,1]); 
R = lmivar(1,[q,1]); 
R1 = lmivar(1,[q1,1]); 
hat_P = lmivar(2,[m,m]);
M1 = lmivar(2,[m,n]);
M2 = lmivar(2,[n,p]); 
M3 = lmivar(2,[n,p]); 
M4 = lmivar(2,[q,p]); 
M5 = lmivar(2,[q,p]); 
M6 = lmivar(2,[q1,p]); 
M7 = lmivar(2,[q1,p]); 

% lmi 1
lmiterm([-1 1 1 0], beta);
lmiterm([-1 1 2 P], 1, B);
lmiterm([-1 1 2 hat_P], -B, 1);
lmiterm([-1 2 2 0], beta);

% lmi 2
lmiterm([-2 1 1 P], 1, 1);
lmiterm([2 1 1 0], 0);

% lmi 3
lmiterm([-3 1 1 Q], 1, 1);
lmiterm([3 1 1 0], 0);

% lmi 4
lmiterm([-4 1 1 R], 1, 1);
lmiterm([4 1 1 0], 0);

% lmi 5
lmiterm([-5 1 1 R1], 1, 1);
lmiterm([5 1 1 0], 0);

% lmi 6
lmiterm([6 1 1 P], 1, A, 's');
lmiterm([6 1 1 M1], B, 1, 's');
lmiterm([6 1 2 M1], -B, 1);
lmiterm([6 1 3 P], 1, B*Kf_sim);
lmiterm([6 1 5 P], 1, D1);
lmiterm([6 1 8 0], Cx');
 
lmiterm([6 2 2 Q], 1, A, 's');
lmiterm([6 2 2 M2], -1, C*A, 's');
lmiterm([6 2 2 M3], -1, C, 's');
lmiterm([6 2 3 Q], 1, F);
lmiterm([6 2 3 M2], -1, C*F);

lmiterm([6 2 4 M3], 1, D2);

lmiterm([6 2 5 Q], 1, D1);
lmiterm([6 2 5 M2], -1, C*D1);

lmiterm([6 2 7 M2], -1, D2);
lmiterm([6 2 8 0], Cex');

lmiterm([6 3 2 M4], -1, C*A);
lmiterm([6 3 2 M5], -1, C);

lmiterm([6 3 3 M4], -1, C*F, 's');
lmiterm([6 3 4 M5], -1, D2);
lmiterm([6 3 5 M4], -1, C*D1);
lmiterm([6 3 6 R], 1, 1);
lmiterm([6 3 7 M4], -1, D2);
lmiterm([6 3 8 0], Cefa');

lmiterm([6 4 2 M6], -1, C*A);
lmiterm([6 4 2 M7], -1, C);

lmiterm([6 4 3 M6], -1, C*F);

lmiterm([6 4 4 M7], -1, D2, 's');
lmiterm([6 4 5 M6], -1, C*D1);
lmiterm([6 4 7 R1], 1, 1);
lmiterm([6 4 7 M6], -1, D2);
lmiterm([6 4 8 0], Cefs');

lmiterm([6 5 5 0], -gamma);
lmiterm([6 6 6 0], -gamma);

lmiterm([6 7 7 0], -gamma);
lmiterm([6 8 8 0], -gamma);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
lmis = getlmis;

[tmin, xfeasp] = feasp(lmis);
P = dec2mat(lmis,  xfeasp, P);
Q = dec2mat(lmis,  xfeasp, Q);
R = dec2mat(lmis,  xfeasp, R);
R1 = dec2mat(lmis,  xfeasp, R1);
hat_P = dec2mat(lmis,  xfeasp, hat_P);
M1 = dec2mat(lmis,  xfeasp, M1);
M2 = dec2mat(lmis,  xfeasp, M2);
M3 = dec2mat(lmis,  xfeasp, M3);
M4 = dec2mat(lmis,  xfeasp, M4);
M5 = dec2mat(lmis,  xfeasp, M5);
M6 = dec2mat(lmis,  xfeasp, M6);
M7 = dec2mat(lmis,  xfeasp, M7);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
Kx_sim = inv(hat_P) * M1;
H1 = inv(Q)*M2;
H2 = inv(R)*M4;
H3 = inv(R1)*M6;
L11 = inv(Q)*M3;
L12 = inv(R)*M5;
L13 = inv(R1)*M7;

H_sim = [H1;H2;H3];
L1 = [L11;L12;L13];
G_sim = eye(4) - H_sim*bar_C;
M_sim = G_sim*bar_A - L1*bar_C;
L2 = M_sim*H_sim;
L_sim = L1 + L2;
